% EV = Cow, Dresser, Skate, Flower
% Contrast:
% 1= C>F
% 2= F>C
% 3= D>F
% 4= F>D
% 5= S>F
% 6= F>S

OP2_CreateFSF('design.fsf','WIPProbe_LO', 'CATVox',4);

mriDir =  '/home/amvanloon/scistor/fmriWorkingMemory/PilotFlowerExamplar/AllPP/ToProcess';
targetDir =  '\\znas0-0.labs.vu.nl\export_FGB-ETP-CogPsy_AMvanLoon\fmriWorkingMemory\PilotFlowerExamplar\AllPP\FSL_FirstLevel_CATVox';

cd(targetDir)
OP2_CopyRegistration(mriDir,targetDir,'WIP','P');
OP2_TransformSubjectToStandard(1,'P');

roiDir = '\\znas0-0.labs.vu.nl\export_FGB-ETP-CogPsy_AMvanLoon\fmriWorkingMemory\PilotFlowerExamplar\AllPP\LO_ROI\LO_TOFm23';

NNCatVox = OP2_GenerateNNStruct(targetDir,roiDir,0,'P');
[Max100Array] = Max100VoxelCatMapper(NNCatVox, 1);
%load('NNLOComb.mat')
TRArray6 = {'1','2','3','4','5', '6'};
[subjectMeanBoldAll6, subjectMeanBoldCon6,OverallMean6] = MeanBoldRetentionCatVox(NNLOComb, Max100Array,1, TRArray6, 0, 1);

TRArray3 = {'7','8','9'};
[subjectMeanBoldAll3, subjectMeanBoldCon3,OverallMean3] = MeanBoldRetentionCatVox(NNLOComb, Max100Array,1, TRArray3, 0, 1);

%Merge the TR's

conditions = fieldnames(subjectMeanBoldAll6);
for iSubject = 1:20
    for iCon = 1:length(conditions)
        subjectMeanBoldAll.(conditions{iCon})(:,1:12) = subjectMeanBoldAll6.(conditions{iCon});
        subjectMeanBoldAll.(conditions{iCon})(:,13:15) = subjectMeanBoldAll3.(conditions{iCon});
    end
end    

%current and prospective conditions with Category voxels and Flower voxels
%conditions: {'CF111A';'CF222B';'FC222A';'FC111B';'DF333A';'DF444B';'FD444A';'FD333B';'SF555A';'SF666B';'FS666A';'FS555B'}

%Select Category > Flower for the prospective conditions: Skate> Flower 666
BOLDCond(:,:,1) = subjectMeanBoldAll.(conditions{2});%Cow>Flower 222
BOLDCond(:,:,2) = subjectMeanBoldAll.(conditions{6});%Dresser>Flower 444
BOLDCond(:,:,3) = subjectMeanBoldAll.(conditions{10});%Skate> Flower 666
%%
%load('MeanBOLD_FigureS1AB.mat')
%Calculate standard error
clear  W X
N = size(BOLDCond,1);
BOLDCondError=NaN(size(BOLDCond,3),size(BOLDCond,2));

for cTR = 1:size(BOLDCond,2)

    X(:,1) = BOLDCond(:,cTR,1);
    X(:,2) = BOLDCond(:,cTR,2);  
    X(:,3) = BOLDCond(:,cTR,3);
    
    W = SEM_MC(X);
   
    Error1 = std(W(:,1),1)/sqrt(N);
    Error2 = std(W(:,2),1)/sqrt(N);
    Error3 = std(W(:,3),1)/sqrt(N); 
 
    BOLDCondError(1,cTR) = Error1;
    BOLDCondError(2,cTR) = Error2;
    BOLDCondError(3,cTR) = Error3;

     
end %cTR





%%
clear perf1 perf2 W X
%Do the same for mean bold of all voxels (Figure S1, mean bold) in pFs
%load('MeanBOLD_FigureS1.mat')

perf1 = meanBoldCurr;
perf2 = meanBoldPros;
    
N = size(perf1,1);
    for cTR = 1:size(perf1,2)
        X(:,1) = perf1(:,cTR);
        X(:,2) = perf2(:,cTR);
        
        W = SEM_MC(X);

        Error1 = std(W(:,1),1)/sqrt(N);
        Error2 = std(W(:,2),1)/sqrt(N);

       SEMBCurr(:,cTR) = Error1;
       SEMBPros(:,cTR) = Error2;
    end
    
GAmeanBoldCurr = mean(meanBoldCurr,1);
GAmeanBoldPros = mean(meanBoldPros,1);
%%
figure
hold on

 %Colors of the lines
blue = [57 72 155]/255;
pink = [227 73 151]/255;

ProsC = [149 121 182]/255;
ProsD = [185 217 137]/255;
ProsS = [253 208 158]/255;

names = {'Cue'; 'TR1'; 'TR2'; 'TR3'; 'TR4';'Search 1';'TR1'; 'TR2'; 'TR3'; 'TR4';'Search 2';'TR1'; 'TR2'; 'TR3'; 'TR4'};

for i = 1:2
    if i ==1
        subplot(2,1,1)
        lh1=shadedErrorBarfunc([1:15],GAmeanBoldCurr,SEMBCurr,blue, 0);
        lh2=shadedErrorBarfunc([1:15],GAmeanBoldPros,SEMBPros,pink,0);
        title({'Mean Bold pFs'})
        lgd=legend([lh1.mainLine,lh2.mainLine], 'Current','Prospective','location', 'northwest', 'orientation', 'vertical');

    elseif i == 2    
        subplot(2,1,2)
        lh1=shadedErrorBarfunc([1:15], squeeze(nanmean(BOLDCond(:,:,1),1)), squeeze(BOLDCondError(1,:)), ProsC,0);
        lh2=shadedErrorBarfunc([1:15], squeeze(nanmean(BOLDCond(:,:,2),1)), squeeze(BOLDCondError(2,:)), ProsD,0); 
        lh3=shadedErrorBarfunc([1:15], squeeze(nanmean(BOLDCond(:,:,3),1)), squeeze(BOLDCondError(3,:)),ProsS,0);
        lgd=legend([lh1.mainLine,lh2.mainLine, lh3.mainLine], 'Cow>Flower','Dresser>Flower', 'Skate>Flower','location', 'northwest', 'orientation', 'vertical');
        title({'Mean Bold Voxel Selection Prospective conditions'})
        
    end    

set(lgd,'FontSize',9); 
legend('boxoff')
set(gca, 'Ylim', [-0.8 0.8])
set(gca, 'Ytick', [-0.8:0.2:0.8])
ylabel({'Mean BOLD (t-values)'},'FontSize',10, 'fontweight', 'bold')

set(gca, 'Xlim', [0.5 15.5])
set(gca,'xtick',[0.5:15.5],'xticklabel',names)
set(gca,'XTickLabelRotation',45)
box off

plot([0.5,15.5],[0,0],':k')
pbaspect([2.5 1 1])
end

print('-dpdf','-r600',  'FigureS1AB_Matlab');
